<?php

include 'db_connect.php';

header('Content-Type: application/json');
$conn = dbConnect();

$data = json_decode(file_get_contents("php://input"), true);
$post_id = $data['post_id'];

$response = array();

$sql = "SELECT likes, loves, cares, wows FROM post_table WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $post_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    $response['likes'] = (int)$row['likes'];
    $response['loves'] = (int)$row['loves'];
    $response['cares'] = (int)$row['cares'];
    $response['wows'] = (int)$row['wows'];
} else {
    $response['likes'] = 0;
    $response['loves'] = 0;
    $response['cares'] = 0;
    $response['wows'] = 0;
}

echo json_encode($response);
