<?php

include_once __DIR__ . '/../secrets.php';

header('Content-Type: application/json; charset=utf-8');
include '../db_connect.php';

$json = file_get_contents('php://input');
$data = json_decode($json, true);

$key = $data['key'];
$user_id = $data['userid'];


$response = [];

$security_key = decrypData($key);

if ($security_key === false) {
    echo 'Invalid encryption data';
    exit;
}

if ($security_key == SECURITY_KEY_PLAIN) {

    $con = dbConnect();

    // ✅ শুধু সেই পোস্ট গুলো নাও যেগুলো ইউজার favorite করেছে
    $postArray = [];
    $postSql = "SELECT post_table.* 
                FROM post_table 
                INNER JOIN favorite_posts ON post_table.id = favorite_posts.post_id 
                WHERE favorite_posts.user_id = '$user_id'
                ORDER BY post_table.id DESC";
    
    $postResult = mysqli_query($con, $postSql);

    while ($item = mysqli_fetch_assoc($postResult)) {
    $post_id = $item['id'];
    $following_id = $item['userid']; // যাকে ফলো করা হতে পারে

    // ✅ ফলো স্ট্যাটাস
    $stmt = $con->prepare("SELECT id FROM followers WHERE follower_id = ? AND following_id = ?");
    $stmt->bind_param("ii", $user_id, $following_id);
    $stmt->execute();
    $followResult = $stmt->get_result();
    $followed = $followResult->num_rows > 0;

    // ✅ রিঅ্যাকশন স্ট্যাটাস
    $stmt2 = $con->prepare("SELECT action FROM post_likes WHERE post_id = ? AND user_id = ?");
    $stmt2->bind_param("ii", $post_id, $user_id);
    $stmt2->execute();
    $likeResult = $stmt2->get_result();
    $likeRow = $likeResult->fetch_assoc();
    $reaction_status = $likeRow ? $likeRow['action'] : "none";

    // ✅ ইউজারের স্ট্যাটাস (signup_table থেকে)
    $status = "";
    $stmt3 = $con->prepare("SELECT status FROM singup_table WHERE id = ?");
    $stmt3->bind_param("i", $following_id);
    $stmt3->execute();
    $statusResult = $stmt3->get_result();
    if ($statusRow = $statusResult->fetch_assoc()) {
        $status = $statusRow['status'];
    }
    
    $url = 'https://votfinity.appnestbd.top/vota/';


    // ✅ পোস্ট ডেটা তৈরি
    $postArray[] = [
        'post_id' => $post_id,
        'userid' => $following_id,
        'name' => $item['name'],
        'profile' => $item['profile'],
        'online' => $item['online'],
        'time' => $item['time'],
        'title' => $item['title'],
        'image1' => $url.$item['image1'],
        'image2' => $url.$item['image2'],
        'image3' => $url.$item['image3'],
        'image4' => $url.$item['image4'],
        'question1' => $item['question1'],
        'question2' => $item['question2'],
        'question3' => $item['question3'],
        'question4' => $item['question4'],
        'likes' => $item['likes'],
        'loves' => $item['loves'],
        'cares' => $item['cares'],
        'wows' => $item['wows'],
        'type' => $item['type'],
        'followed' => $followed,
        'reaction_status' => $reaction_status,
        'status' => $status // ⬅️ নতুন যোগ
    ];
}

    $response['posts'] = $postArray;
    echo json_encode($response);

} 


?>
