<?php

include '../db_connect.php'; 

$con = dbConnect(); 

header("Content-Type: application/json");

$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

if ($user_id > 0) {
    $stmt = $con->prepare("SELECT COUNT(*) AS total_posts, SUM(likes) AS total_likes, SUM(dislikes) AS total_dislikes FROM post_table WHERE userid = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($row = $result->fetch_assoc()) {
        $response = [
            "success" => true,
            "total_posts" => $row['total_posts'] ?? 0,
            "total_likes" => $row['total_likes'] ?? 0,
            "total_dislikes" => $row['total_dislikes'] ?? 0
        ];
    } else {
        $response = ["success" => false, "message" => "No posts found!"];
    }

    $stmt->close();
} else {
    $response = ["success" => false, "message" => "Invalid user ID!"];
}

echo json_encode($response);
$con->close();

?>
