<?php
include 'db_connect.php';

$json = file_get_contents('php://input');
$data = json_decode($json, true);

$key = $data['key'] ?? '';
$userid = $data['userid'] ?? '';

$security_key = decryptData($key);

if ($security_key === 'Jobayer121415' && !empty($userid)) {
    $con = dbConnect();

    // ইউজারের বেসিক তথ্য
    $sql = "SELECT * FROM singup_table WHERE id = ?";
    $stmt = $con->prepare($sql);
    $stmt->bind_param("i", $userid);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($user = $result->fetch_assoc()) {
        // Followers count
        $followers_sql = "SELECT COUNT(*) AS followers_count FROM followers WHERE following_id = ?";
        $stmt1 = $con->prepare($followers_sql);
        $stmt1->bind_param("i", $userid);
        $stmt1->execute();
        $followers_result = $stmt1->get_result();
        $followers_count = $followers_result->fetch_assoc()["followers_count"];

        // Following count
        $following_sql = "SELECT COUNT(*) AS following_count FROM followers WHERE follower_id = ?";
        $stmt2 = $con->prepare($following_sql);
        $stmt2->bind_param("i", $userid);
        $stmt2->execute();
        $following_result = $stmt2->get_result();
        $following_count = $following_result->fetch_assoc()["following_count"];

       $Url = 'https://votfinity.appnestbd.top/vota/update/';

        // সব ডেটা একসাথে পাঠানো
        $response = [
            'id' => $user['id'],
            'name' => $user['name'],
            'email' => $user['email'],
            'phone' => $user['phone'],
            'password' => $user['password'],
            'image' => $Url.$user['image'],
            'time' => $user['time'],
            'cover' => $Url.$user['cover'],
            'gender' => $user['gender'],
            'birthdate' => $user['birthdate'],
            'country' => $user['country'],
            'bio' => $user['bio'],
            'token' => $user['token'],
            'status' => $user['status'],
            'followers' => $followers_count,
            'following' => $following_count
        ];

        echo json_encode($response);
    } else {
        echo json_encode(['error' => 'No user found']);
    }
} else {
    echo json_encode(['error' => 'Invalid key or userid']);
}

// ডাটা ডিক্রিপশন ফাংশন
function decryptData($text) {
    $decoded = base64_decode($text);
    return openssl_decrypt($decoded, 'AES-128-ECB', '0175526800812345', OPENSSL_RAW_DATA);
}
?>
