<?php
$host = '0.0.0.0';
$port = 8080;
$server = stream_socket_server("tcp://$host:$port", $errno, $errstr);

if (!$server) {
    die("Server creation failed: $errstr ($errno)");
}

$clients = [];

while (true) {
    $read = $clients;
    $read[] = $server;
    
    stream_select($read, $write, $except, 0);
    
    if (in_array($server, $read)) {
        $client = stream_socket_accept($server);
        $clients[] = $client;
    }
    
    foreach ($clients as $key => $client) {
        $data = fread($client, 1024);
        if (!$data) {
            fclose($client);
            unset($clients[$key]);
            continue;
        }

        foreach ($clients as $send_client) {
            fwrite($send_client, json_encode(["message" => "update"]));
        }
    }
}
?>
